SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
  `id_backup` int(11) unsigned NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `id_bank` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) DEFAULT NULL,
  `pengeluaran` int(11) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `noref_nokartu` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `id_bank_akun` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank_akun`;
CREATE TABLE `bank_akun` (
  `id_bank_akun` int(11) NOT NULL,
  `nama_bank` varchar(255) DEFAULT NULL,
  `bank_nama` varchar(255) DEFAULT NULL,
  `no_rekening` varchar(255) DEFAULT NULL,
  `utama` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `bank_akun` (`id_bank_akun`,`nama_bank`,`bank_nama`,`no_rekening`,`utama`,`created_at`,`updated_at`) VALUES ('1','BANK 1, Purwokerto','John Doe','123456789','0',NULL,'2025-10-05 06:51:44'), 
('2','Shopeepay','Shopeepay','08123456789','1','2025-10-05 06:48:45','2025-10-05 06:51:44');
DROP TABLE IF EXISTS `barang`;
CREATE TABLE `barang` (
  `id_barang` int(11) unsigned NOT NULL,
  `uuid_barang` char(36) NOT NULL DEFAULT '',
  `kode_barang` varchar(255) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `id_kategori` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `nama_barang` varchar(255) NOT NULL DEFAULT '',
  `merk` varchar(255) NOT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `harga_pelanggan` int(11) NOT NULL DEFAULT 0,
  `harga_sales` int(11) NOT NULL DEFAULT 0,
  `range_harga` varchar(255) DEFAULT NULL,
  `satuan_barang` varchar(255) NOT NULL,
  `satuan_nilai` int(11) NOT NULL DEFAULT 0,
  `deskripsi` text DEFAULT NULL,
  `stok` int(11) NOT NULL DEFAULT 0,
  `stok_min` int(11) NOT NULL DEFAULT 0,
  `stok_gudang` int(11) NOT NULL DEFAULT 0,
  `expired` datetime DEFAULT NULL,
  `active` int(11) DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `barang` (`id_barang`,`uuid_barang`,`kode_barang`,`barcode`,`id_kategori`,`id_kontak`,`sku`,`nama_barang`,`merk`,`harga_beli`,`diskon`,`diskon_persen`,`harga_jual`,`harga_pelanggan`,`harga_sales`,`range_harga`,`satuan_barang`,`satuan_nilai`,`deskripsi`,`stok`,`stok_min`,`stok_gudang`,`expired`,`active`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','c2FsbvWSQeBAP5WtfWsh4d','BRG-00001','8990000000010','5','2','BRG-001','8 PCS SABUN K NATURAL WHITE 85GRAM FREE 2 TEPAK -Soap','Sabun','20000','2000','6','32000','0','0',NULL,'pcs','8','Paket ini berisi 8 buah sabun dengan berat 85 gram setiapnya. ????
Dilengkapi dengan 2 tepak gratis. ????
Sabun K Natural White menawarkan pilihan wangi yang menarik. ????
Cocok untuk pengguna yang mencari sabun dengan berbagai varian wangi. ????
Pastikan untuk memilih varian yang sesuai dengan kebutuhan Anda. ????','500','1','0','2027-10-31 00:00:00','1','1','2025-10-05 20:47:50','2025-10-05 20:49:15'), 
('2','TfxszdPjJn2r93q2H28VAe','BRG-00002','8990000000027','5','2','BRG-002','Giv Bar Soap White Hijab Saffron & Niacinamide','Sabun','3000','0','0','4500','0','0',NULL,'pcs','1','GIV White Hijab sabun mandi (bodywash) dengan kandungan Saffron & Niacinamide, membuat kulit glowing seperti permata.
Keunggulan :
1. Mengandung Saffron & Niacinamide membantu mencerahkan kulit,
2. Sabun Mandi Halal & cocok untuk hijabers,
3. Membantu menjaga kelembapan kulit meski dibalik hijab,
4. Lembut busanya saat dipakai mandi.','200','10','0','2027-10-14 00:00:00','0','1','2025-10-05 20:56:54','2025-10-05 20:57:42'), 
('3','4Ca2y85NED3QXfmDQ6G6wm','BRG-00003','8990000000034','6','2','BRG-003','Bango Kecap Manis Refill Pouch Besar 950G','Bahan Makanan','11000','0','0','16000','0','0',NULL,'gram','1','Kecap Manis Bango / Soy Sauce Refill 950G terbuat dari 100% bahan alami yang berkualitas tinggi: kedelai hitam Mallika, gula, garam dan air.','100','1','0','2026-08-12 00:00:00','0','1','2025-10-05 21:04:24','2025-10-05 21:04:49'), 
('4','bBqNHqof5Cg7VExFvmSWtW','BRG-00004','8990000000011','6','2','BRG-004','DUA BELIBIS VALUE SAOS CABE POUCH','Bahan Makanan','17000','1500','6','24200','0','0',NULL,'kg','1','DUA BELIBIS VALUE SAOS CABE (1kg)✨ Rasakan Keistimewaan Saus Cabe Dua Belibis ✨
• Saus Cabe Dua Belibis terbuat dari bahan berkualitas dan premium. Perpaduan rasa cabai dan bawang dengan konsentrasi yang tinggi menjadikan saus sambal ini lebih istimewa.
• Kemasan Praktis: Kemasan Pouch dengan berat 1 kg, saus ini siap memenuhi kebutuhan Anda. Cocok untuk berbagai hidangan yang membutuhkan rasa cabai yang kaya. Rasakan perbedaannya dalam setiap penggunaan.','149','10','0','2026-02-02 00:00:00','1','1','2025-10-05 21:08:56','2025-10-06 02:12:20');
DROP TABLE IF EXISTS `biaya`;
CREATE TABLE `biaya` (
  `id_biaya` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cashflow`;
CREATE TABLE `cashflow` (
  `id_cashflow` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `kategori` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int(11) NOT NULL DEFAULT 0,
  `pengeluaran` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_biaya` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `cashflow` (`id_cashflow`,`faktur`,`jenis`,`kategori`,`tanggal`,`waktu`,`pemasukan`,`pengeluaran`,`keterangan`,`id_penjualan`,`id_pembelian`,`id_biaya`,`id_toko`,`id_login`,`created_at`,`updated_at`) VALUES ('1','PJ/061025-021220','Pemasukan','Penjualan','2025-10-06','02:12:20','20700','0','Penjualan: PJ/061025-021220','1',NULL,NULL,'1','1','2025-10-06 02:12:20',NULL);
DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id_group` int(11) NOT NULL,
  `nama_group` varchar(255) NOT NULL,
  `permission` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `groups` (`id_group`,`nama_group`,`permission`,`created_at`,`updated_at`) VALUES ('1','Administrator','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2025-10-05 10:53:03'), 
('2','Manager','a:84:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:12:\"deleteBarang\";i:7;s:9:\"viewExcel\";i:8;s:11:\"createExcel\";i:9;s:13:\"viewStokInOut\";i:10;s:15:\"createStokInOut\";i:11;s:15:\"updateStokInOut\";i:12;s:15:\"deleteStokInOut\";i:13;s:14:\"viewStokOpname\";i:14;s:16:\"createStokOpname\";i:15;s:16:\"updateStokOpname\";i:16;s:16:\"deleteStokOpname\";i:17;s:13:\"menuTransaksi\";i:18;s:13:\"viewPenjualan\";i:19;s:15:\"createPenjualan\";i:20;s:15:\"updatePenjualan\";i:21;s:15:\"deletePenjualan\";i:22;s:13:\"viewPembelian\";i:23;s:15:\"createPembelian\";i:24;s:15:\"updatePembelian\";i:25;s:15:\"deletePembelian\";i:26;s:10:\"viewHutang\";i:27;s:12:\"createHutang\";i:28;s:12:\"updateHutang\";i:29;s:12:\"deleteHutang\";i:30;s:11:\"viewPiutang\";i:31;s:13:\"createPiutang\";i:32;s:13:\"updatePiutang\";i:33;s:13:\"deletePiutang\";i:34;s:9:\"viewBiaya\";i:35;s:11:\"createBiaya\";i:36;s:11:\"updateBiaya\";i:37;s:11:\"deleteBiaya\";i:38;s:12:\"menuKeuangan\";i:39;s:12:\"viewCashflow\";i:40;s:14:\"createCashflow\";i:41;s:14:\"updateCashflow\";i:42;s:14:\"deleteCashflow\";i:43;s:8:\"viewBank\";i:44;s:10:\"createBank\";i:45;s:10:\"updateBank\";i:46;s:10:\"deleteBank\";i:47;s:9:\"viewPajak\";i:48;s:11:\"createPajak\";i:49;s:11:\"updatePajak\";i:50;s:11:\"deletePajak\";i:51;s:10:\"menuKontak\";i:52;s:10:\"viewKontak\";i:53;s:12:\"createKontak\";i:54;s:12:\"updateKontak\";i:55;s:12:\"deleteKontak\";i:56;s:8:\"menuUser\";i:57;s:8:\"viewUser\";i:58;s:10:\"createUser\";i:59;s:10:\"updateUser\";i:60;s:10:\"deleteUser\";i:61;s:9:\"viewGroup\";i:62;s:11:\"createGroup\";i:63;s:11:\"updateGroup\";i:64;s:11:\"deleteGroup\";i:65;s:11:\"menuSetting\";i:66;s:11:\"viewSetting\";i:67;s:13:\"updateSetting\";i:68;s:10:\"viewConfig\";i:69;s:12:\"updateConfig\";i:70;s:12:\"viewBankAkun\";i:71;s:14:\"createBankAkun\";i:72;s:14:\"updateBankAkun\";i:73;s:14:\"deleteBankAkun\";i:74;s:10:\"viewBackup\";i:75;s:12:\"createBackup\";i:76;s:12:\"deleteBackup\";i:77;s:11:\"viewLaporan\";i:78;s:11:\"menuLaporan\";i:79;s:19:\"viewLaporanLabaRugi\";i:80;s:13:\"viewStatistik\";i:81;s:13:\"menuStatistik\";i:82;s:11:\"updateShift\";i:83;s:11:\"deleteShift\";}',NULL,'2025-10-05 10:56:57'), 
('3','Kasir','a:29:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:13:\"menuTransaksi\";i:3;s:13:\"viewPenjualan\";i:4;s:15:\"createPenjualan\";i:5;s:15:\"updatePenjualan\";i:6;s:11:\"viewPiutang\";i:7;s:13:\"createPiutang\";i:8;s:13:\"updatePiutang\";i:9;s:9:\"viewBiaya\";i:10;s:11:\"createBiaya\";i:11;s:11:\"updateBiaya\";i:12;s:12:\"menuKeuangan\";i:13;s:12:\"viewCashflow\";i:14;s:14:\"createCashflow\";i:15;s:10:\"createBank\";i:16;s:9:\"viewPajak\";i:17;s:11:\"createPajak\";i:18;s:10:\"menuKontak\";i:19;s:10:\"viewKontak\";i:20;s:12:\"createKontak\";i:21;s:12:\"updateKontak\";i:22;s:10:\"viewConfig\";i:23;s:12:\"viewBankAkun\";i:24;s:11:\"viewLaporan\";i:25;s:11:\"menuLaporan\";i:26;s:13:\"viewStatistik\";i:27;s:13:\"menuStatistik\";i:28;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:32'), 
('4','Sales','a:8:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuKontak\";i:3;s:10:\"viewKontak\";i:4;s:12:\"createKontak\";i:5;s:12:\"updateKontak\";i:6;s:12:\"deleteKontak\";i:7;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:40'), 
('5','Gudang','a:15:{i:0;s:13:\"viewDashboard\";i:1;s:13:\"menuDashboard\";i:2;s:10:\"menuBarang\";i:3;s:10:\"viewBarang\";i:4;s:12:\"createBarang\";i:5;s:12:\"updateBarang\";i:6;s:9:\"viewExcel\";i:7;s:11:\"createExcel\";i:8;s:13:\"viewStokInOut\";i:9;s:15:\"createStokInOut\";i:10;s:15:\"updateStokInOut\";i:11;s:14:\"viewStokOpname\";i:12;s:16:\"createStokOpname\";i:13;s:16:\"updateStokOpname\";i:14;s:11:\"updateShift\";}',NULL,'2025-10-05 20:22:49');
DROP TABLE IF EXISTS `hutang`;
CREATE TABLE `hutang` (
  `id_hutang` int(11) unsigned NOT NULL,
  `id_pembelian` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_hutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_hutang` int(11) DEFAULT NULL,
  `status_hutang` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `hutang_bayar`;
CREATE TABLE `hutang_bayar` (
  `id_hutang_bayar` int(11) unsigned NOT NULL,
  `id_hutang` int(11) unsigned NOT NULL,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kategori`;
CREATE TABLE `kategori` (
  `id_kategori` int(11) unsigned NOT NULL,
  `nama_kategori` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kategori` (`id_kategori`,`nama_kategori`,`created_at`,`updated_at`) VALUES ('1','Kopi',NULL,NULL), 
('2','Beras','2025-10-05 15:52:25','2025-10-05 15:52:25'), 
('3','Sembako','2025-10-05 15:54:04','2025-10-05 15:54:04'), 
('4','Rokok','2025-10-05 20:37:40','2025-10-05 20:37:40'), 
('5','Sabun','2025-10-05 20:41:44','2025-10-05 20:41:52'), 
('6','Bahan Makanan','2025-10-05 21:02:18','2025-10-05 21:02:18');
DROP TABLE IF EXISTS `keranjang`;
CREATE TABLE `keranjang` (
  `id_keranjang` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `kontak`;
CREATE TABLE `kontak` (
  `id_kontak` int(11) unsigned NOT NULL,
  `tipe` varchar(255) DEFAULT NULL,
  `grup` varchar(255) DEFAULT NULL,
  `nama` varchar(255) NOT NULL,
  `perusahaan` varchar(255) DEFAULT NULL,
  `alamat` text NOT NULL,
  `telepon` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `nikktp` varchar(16) DEFAULT NULL,
  `npwp` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `kontak` (`id_kontak`,`tipe`,`grup`,`nama`,`perusahaan`,`alamat`,`telepon`,`email`,`nikktp`,`npwp`,`created_at`,`updated_at`) VALUES ('1','Pelanggan',NULL,'Umum',NULL,'Bojong','085227058196','member@gmail.com','12314121',NULL,NULL,'2025-10-05 21:12:21'), 
('2','Vendor',NULL,'Aan','Iklip Collections','Tegal','085786811630','sabun@gmail.com','123456789',NULL,'2025-10-05 12:59:50','2025-10-05 21:11:53'), 
('3','Pelanggan',NULL,'Customer',NULL,'Tegal','62812345678','customer@gmail.com','1213151416',NULL,'2025-10-05 12:59:50','2025-10-05 21:13:33');
DROP TABLE IF EXISTS `login`;
CREATE TABLE `login` (
  `id_login` int(11) NOT NULL,
  `email` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) DEFAULT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL DEFAULT '',
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `token` varchar(255) DEFAULT NULL,
  `role` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login` (`id_login`,`email`,`nama`,`username`,`password`,`id_toko`,`token`,`role`,`active`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','Administrator','admin','$2y$10$INo6IRmOXz4YqFhdxnzRjuqgKGaOuOlhBpxClF5V8xd1KPnmhq.9G','1',NULL,'1','1',NULL,'2025-10-05 12:59:50'), 
('2','kasir@gmail.com','Kasir','kasir','$2y$10$iTLV.WtmYghGjOSnIHJr8eTF0xFzCJTHOemBLK0tCvlpkeBgOWHk2','1',NULL,'2','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('3','manager@gmail.com','Manager','manager','$2y$10$dKFJw/2EF/ki.lT5dBz6auWJnVqtBeYHbWPUpNaXq28mTAzR328Hq','1',NULL,'3','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('4','sales@gmail.com','Sales','sales','$2y$10$4fagP5P0VulbcRe7Tcyq..WEEszuMgkb2MHOzEe4JjPWSGoywjNxC','1',NULL,'4','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('5','gudang@gmail.com','Gudang','gudang','$2y$10$9fZGZFOqt8bAclgOIvCkcuFUAiL.PSzhrIcWT3n7GmhSg9h6B5y22','1',NULL,'5','1','2025-10-05 12:59:50','2025-10-05 12:59:50');
DROP TABLE IF EXISTS `login_group`;
CREATE TABLE `login_group` (
  `id_login_group` int(11) NOT NULL,
  `id_login` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_group` (`id_login_group`,`id_login`,`id_group`,`created_at`,`updated_at`) VALUES ('1','1','1',NULL,NULL), 
('2','2','3',NULL,NULL), 
('3','3','2',NULL,'2025-10-05 15:10:06'), 
('4','4','4',NULL,NULL), 
('5','5','5',NULL,'2025-10-05 15:04:22');
DROP TABLE IF EXISTS `login_log`;
CREATE TABLE `login_log` (
  `id_log_login` int(11) unsigned NOT NULL,
  `email` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL,
  `loggedin_at` datetime DEFAULT NULL,
  `loggedout_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `login_log` (`id_log_login`,`email`,`username`,`loggedin_at`,`loggedout_at`,`created_at`,`updated_at`) VALUES ('1','admin@gmail.com','admin','2025-10-05 03:38:12','2025-10-05 06:43:12','2025-10-05 03:38:12','2025-10-05 06:43:12'), 
('2','admin@gmail.com','admin','2025-10-05 13:42:30','2025-10-05 14:29:36','2025-10-05 13:42:30','2025-10-05 14:29:36'), 
('3','admin@gmail.com','admin','2025-10-05 14:07:49','2025-10-05 19:28:16','2025-10-05 14:07:49','2025-10-05 19:28:16'), 
('4','admin@gmail.com','admin','2025-10-05 19:28:16','2025-10-06 01:45:51','2025-10-05 19:28:16','2025-10-06 01:45:51'), 
('5','admin@gmail.com','admin','2025-10-06 01:45:51','2025-10-06 05:46:27','2025-10-06 01:45:51','2025-10-06 05:46:27'), 
('6','admin@gmail.com','admin','2025-10-06 05:46:27','2025-10-06 05:57:21','2025-10-06 05:46:27','2025-10-06 05:57:21'), 
('7','admin@gmail.com','admin','2025-10-06 06:46:29','2025-10-08 07:11:06','2025-10-06 06:46:29','2025-10-08 07:11:06'), 
('0','admin@gmail.com','admin','2025-10-08 07:11:06','2025-10-08 07:17:56','2025-10-08 07:11:06','2025-10-08 07:17:56'), 
('0','admin@gmail.com','admin','2025-10-08 07:20:55',NULL,'2025-10-08 07:20:55','2025-10-08 07:20:55');
DROP TABLE IF EXISTS `logs`;
CREATE TABLE `logs` (
  `id_log` int(11) unsigned NOT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `logs` (`id_log`,`keterangan`,`created_at`) VALUES ('1','Administrator (admin@gmail.com) melakukan Logout at: 2023-11-04 16:47:52','2023-11-04 16:47:52'), 
('2','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 03:38:12 on device/s: Windows 10/Firefox 140.0','2025-10-05 03:38:12'), 
('3','Administrator (admin@gmail.com) melakukan Save Backup: db_copos-051025-041729.sql','2025-10-05 04:17:29'), 
('4','Administrator (admin@gmail.com) melakukan Save Open Cashier: 1','2025-10-05 04:26:29'), 
('5','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 1','2025-10-05 04:26:29'), 
('6','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-05 06:43:12','2025-10-05 06:43:12'), 
('7','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 13:42:30 on device/s: Windows 10/Firefox 140.0','2025-10-05 13:42:30'), 
('8','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 14:07:49 on device/s: Windows 10/Opera 120.0.0.0','2025-10-05 14:07:49'), 
('9','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-05 14:29:36','2025-10-05 14:29:36'), 
('10','Administrator (admin@gmail.com) melakukan Login at: 2025-10-05 19:28:16 on device/s: Windows 10/Firefox 140.0','2025-10-05 19:28:16'), 
('11','Administrator (admin@gmail.com) melakukan Save Kategori: Sabun','2025-10-05 20:41:44'), 
('12','Administrator (admin@gmail.com) melakukan Update Kategori: 5','2025-10-05 20:41:52'), 
('13','Administrator (admin@gmail.com) melakukan Update Kontak: 2','2025-10-05 20:46:04'), 
('14','Administrator (admin@gmail.com) melakukan Save Barang: c2FsbvWSQeBAP5WtfWsh4d','2025-10-05 20:47:50'), 
('15','Administrator (admin@gmail.com) melakukan Update Barang: 1','2025-10-05 20:49:15'), 
('16','Administrator (admin@gmail.com) melakukan Save Barang: TfxszdPjJn2r93q2H28VAe','2025-10-05 20:56:54'), 
('17','Administrator (admin@gmail.com) melakukan Update Barang: 2','2025-10-05 20:57:42'), 
('18','Administrator (admin@gmail.com) melakukan Save Kategori: Bahan Makanan','2025-10-05 21:02:18'), 
('19','Administrator (admin@gmail.com) melakukan Save Barang: 4Ca2y85NED3QXfmDQ6G6wm','2025-10-05 21:04:24'), 
('20','Administrator (admin@gmail.com) melakukan Update Barang: 3','2025-10-05 21:04:49'), 
('21','Administrator (admin@gmail.com) melakukan Save Barang: bBqNHqof5Cg7VExFvmSWtW','2025-10-05 21:08:56'), 
('22','Administrator (admin@gmail.com) melakukan Update Barang: 4','2025-10-05 21:09:53'), 
('23','Administrator (admin@gmail.com) melakukan Update Barang: 4','2025-10-05 21:10:28'), 
('24','Administrator (admin@gmail.com) melakukan Update Kontak: 2','2025-10-05 21:11:53'), 
('25','Administrator (admin@gmail.com) melakukan Update Kontak: 1','2025-10-05 21:12:21'), 
('26','Administrator (admin@gmail.com) melakukan Update Kontak: 4','2025-10-05 21:12:51'), 
('27','Administrator (admin@gmail.com) melakukan Update Kontak: 3','2025-10-05 21:13:33'), 
('28','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 01:45:51 on device/s: Windows 10/Firefox 140.0','2025-10-06 01:45:51'), 
('29','Administrator (admin@gmail.com) melakukan Save Open Cashier: 2','2025-10-06 01:53:58'), 
('30','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 2','2025-10-06 01:53:58'), 
('31','Administrator (admin@gmail.com) melakukan Save Penjualan - Cash: PJ/061025-021220','2025-10-06 02:12:20'), 
('32','Administrator (admin@gmail.com) melakukan Save Cashflow: PJ/061025-021220','2025-10-06 02:12:20'), 
('33','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 05:46:27 on device/s: Windows 10/Firefox 140.0','2025-10-06 05:46:27'), 
('34','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-06 05:57:21','2025-10-06 05:57:21'), 
('35','Administrator (admin@gmail.com) melakukan Login at: 2025-10-06 06:46:29 on device/s: Windows 10/Firefox 140.0','2025-10-06 06:46:29'), 
('0','Administrator (admin@gmail.com) melakukan Login at: 2025-10-08 07:11:06 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-08 07:11:06'), 
('0','Administrator (admin@gmail.com) melakukan Save Open Cashier: 0','2025-10-08 07:13:21'), 
('0','Administrator (admin@gmail.com) melakukan Save Detail Open Cashier: 0','2025-10-08 07:13:21'), 
('0','Administrator (admin@gmail.com) melakukan Delete Kontak: 5','2025-10-08 07:16:48'), 
('0','Administrator (admin@gmail.com) melakukan Delete Kontak: 4','2025-10-08 07:16:52'), 
('0','Administrator (admin@gmail.com) melakukan Logout at: 2025-10-08 07:17:56','2025-10-08 07:17:56'), 
('0','Administrator (admin@gmail.com) melakukan Login at: 2025-10-08 07:20:55 on device/s: Windows 10/Chrome 140.0.0.0','2025-10-08 07:20:55'), 
('0','Administrator (admin@gmail.com) melakukan Delete Backup: 1','2025-10-08 07:21:35');
DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
  `id_media` int(11) unsigned NOT NULL,
  `media_path` varchar(255) NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `active` int(11) DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `media` (`id_media`,`media_path`,`id_barang`,`active`,`created_at`,`updated_at`,`deleted_at`) VALUES ('1','images/1759671528_6a33c01f8be36e38188c.jpg','0','1','2025-10-05 20:38:48','2025-10-05 20:38:48',NULL), 
('2','images/1759672128_fb8d44623179fca006a0.jpg','1','1','2025-10-05 20:48:48','2025-10-05 20:48:48',NULL), 
('3','images/1759672496_0e5ea7ca5b83718893bf.jpg','0','1','2025-10-05 20:54:56','2025-10-05 20:54:56',NULL), 
('4','images/1759672625_a80c643c0e55ba5d857b.jpg','2','1','2025-10-05 20:57:05','2025-10-05 20:57:05',NULL), 
('6','images/1759673074_ea672afecc7fd639bea0.jpg','3','1','2025-10-05 21:04:34','2025-10-05 21:04:34',NULL), 
('7','images/1759673211_942d55ebdbaef9761ba1.jpg','0','1','2025-10-05 21:06:51','2025-10-05 21:06:51',NULL), 
('8','images/1759673409_90223d05e98377b5bd7e.jpg','4','1','2025-10-05 21:10:09','2025-10-05 21:10:09',NULL);
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id_order` varchar(20) NOT NULL DEFAULT '',
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) NOT NULL DEFAULT 0,
  `harga_jual` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pajak`;
CREATE TABLE `pajak` (
  `id_pajak` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int(11) DEFAULT NULL,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian`;
CREATE TABLE `pembelian` (
  `id_pembelian` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `biaya` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `status_bayar` int(11) NOT NULL DEFAULT 0,
  `pembayaran` int(11) DEFAULT NULL,
  `catatan` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `pembelian_item`;
CREATE TABLE `pembelian_item` (
  `id_itempembelian` int(11) unsigned NOT NULL,
  `id_pembelian` int(11) unsigned DEFAULT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `jumlah` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `penjualan`;
CREATE TABLE `penjualan` (
  `id_penjualan` int(11) unsigned NOT NULL,
  `faktur` varchar(255) DEFAULT NULL,
  `id_kontak` int(11) unsigned NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `PPN` char(10) NOT NULL DEFAULT '0',
  `hpp` int(11) NOT NULL DEFAULT 0,
  `subtotal` int(11) NOT NULL DEFAULT 0,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `pajak` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `bayar` int(11) NOT NULL DEFAULT 0,
  `kembali` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `periode` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `metode_bayar` varchar(255) DEFAULT NULL,
  `catatan` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `penjualan` (`id_penjualan`,`faktur`,`id_kontak`,`jumlah`,`PPN`,`hpp`,`subtotal`,`diskon`,`diskon_persen`,`pajak`,`pembulatan`,`total`,`bayar`,`kembali`,`total_laba`,`periode`,`id_login`,`id_toko`,`metode_bayar`,`catatan`,`created_at`,`updated_at`) VALUES ('1','PJ/061025-021220','1','1','0','17000','22700','2000','9','0','0','20700','100000','79300','5700','10-2025','1','1','cash','','2025-10-06 02:12:20',NULL);
DROP TABLE IF EXISTS `penjualan_item`;
CREATE TABLE `penjualan_item` (
  `id_itempenjualan` int(11) unsigned NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `id_penjualan` int(11) unsigned DEFAULT NULL,
  `harga_beli` int(11) DEFAULT NULL,
  `harga_jual` int(11) DEFAULT NULL,
  `diskon` int(11) NOT NULL DEFAULT 0,
  `diskon_persen` int(11) NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `satuan` varchar(255) DEFAULT NULL,
  `hpp` int(11) NOT NULL DEFAULT 0,
  `jumlah` int(11) DEFAULT NULL,
  `ppn` int(11) NOT NULL DEFAULT 0,
  `total_laba` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `penjualan_item` (`id_itempenjualan`,`id_barang`,`id_penjualan`,`harga_beli`,`harga_jual`,`diskon`,`diskon_persen`,`stok`,`qty`,`satuan`,`hpp`,`jumlah`,`ppn`,`total_laba`,`created_at`,`updated_at`) VALUES ('1','4','1','17000','24200','1500','6','150','1','1 kg','17000','22700','0','5700','2025-10-06 02:12:20',NULL);
DROP TABLE IF EXISTS `piutang`;
CREATE TABLE `piutang` (
  `id_piutang` int(11) unsigned NOT NULL,
  `id_penjualan` int(11) unsigned NOT NULL,
  `tanggal` date DEFAULT NULL,
  `jatuh_tempo` date DEFAULT NULL,
  `jumlah_piutang` int(11) DEFAULT NULL,
  `jumlah_bayar` int(11) DEFAULT NULL,
  `sisa_piutang` int(11) DEFAULT NULL,
  `status_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `id_toko` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `piutang_bayar`;
CREATE TABLE `piutang_bayar` (
  `id_piutang_bayar` int(11) unsigned NOT NULL,
  `id_piutang` int(11) unsigned NOT NULL DEFAULT 0,
  `nominal` int(11) DEFAULT NULL,
  `id_cashflow` int(11) unsigned NOT NULL DEFAULT 0,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `satuan`;
CREATE TABLE `satuan` (
  `id_satuan` int(11) unsigned NOT NULL,
  `nama_satuan` varchar(255) NOT NULL DEFAULT '',
  `nilai_satuan` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `satuan` (`id_satuan`,`nama_satuan`,`nilai_satuan`,`created_at`,`updated_at`) VALUES ('1','pcs','1',NULL,NULL), 
('2','buah','1',NULL,NULL), 
('3','butir','1',NULL,NULL), 
('4','bungkus','1','2025-10-05 12:59:50','2025-10-05 12:59:50'), 
('5','gram','100',NULL,NULL), 
('6','kg','1',NULL,NULL), 
('7','roll','1',NULL,NULL), 
('8','lembar','1',NULL,NULL);
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) unsigned NOT NULL,
  `group_setting` varchar(100) NOT NULL,
  `variable_setting` varchar(255) NOT NULL,
  `value_setting` text NOT NULL,
  `deskripsi_setting` varchar(255) NOT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `settings` (`id`,`group_setting`,`variable_setting`,`value_setting`,`deskripsi_setting`,`updated_at`) VALUES ('1','general','app_name','Toko Cahaya Berkah','App Name','2025-10-05 06:16:12'), 
('2','general','app_version','1','App Version','2025-10-05 18:22:10'), 
('3','general','app_release','2025-10-05 08:24:55','App Release','2025-10-05 08:24:55'), 
('4','general','app_developer','Toko Cahaya Berkah','App Developer','2025-10-05 17:05:03'), 
('5','image','img_favicon','assets/images/favicon.png','Favicon','2025-10-05 13:14:59'), 
('6','image','img_logo','assets/images/logo.png','Logo','2025-10-05 09:47:27'), 
('7','image','img_logo_resize','assets/images/res_logo.png','Logo Resized','2025-10-05 09:47:28'), 
('8','image','img_background','assets/images/background.jpg','Background','2025-10-05 13:17:10'), 
('9','app','snackbars_position','bottom','Posisi Snackbars Notification','2025-10-05 07:22:22'), 
('10','app','limit_loginlog','2000','Limit Login Log (default 2000)','2025-10-05 08:24:55'), 
('11','app','enable_frontend','true','Tampilkan Home atau Halaman Login','2025-10-05 18:22:33'), 
('12','app','cashierpay_position','left','Posisi Tombol Pay Kasir','2025-10-05 13:18:48');
DROP TABLE IF EXISTS `shift`;
CREATE TABLE `shift` (
  `id_shift` int(11) NOT NULL,
  `nama_shift` varchar(255) DEFAULT NULL,
  `jam_mulai` time DEFAULT NULL,
  `jam_selesai` time DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `shift` (`id_shift`,`nama_shift`,`jam_mulai`,`jam_selesai`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','Shift 1','07:00:00','15:00:00','1',NULL,'2025-10-05 12:59:50'), 
('2','Shift 2','15:00:00','21:00:00','1',NULL,'2025-10-05 12:59:50'), 
('3','Shift 3','00:00:00','00:00:00','1',NULL,NULL), 
('4',NULL,NULL,NULL,'1',NULL,NULL), 
('5',NULL,NULL,NULL,'1',NULL,NULL);
DROP TABLE IF EXISTS `shift_openclose`;
CREATE TABLE `shift_openclose` (
  `id_shift_openclose` int(11) unsigned NOT NULL,
  `id_shift` int(11) NOT NULL,
  `type` char(20) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `id_login` int(11) NOT NULL DEFAULT 0,
  `supervisor` int(11) NOT NULL DEFAULT 0,
  `jumlah_uang_kertas` int(11) DEFAULT NULL,
  `jumlah_uang_koin` int(11) DEFAULT NULL,
  `id_toko` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `shift_openclose` (`id_shift_openclose`,`id_shift`,`type`,`tanggal`,`waktu`,`id_login`,`supervisor`,`jumlah_uang_kertas`,`jumlah_uang_koin`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','1','open','2025-10-05','04:18:00','1','3','950000','50000','1','2025-10-05 04:26:29','2025-10-05 04:26:29'), 
('2','3','open','2025-10-06','01:51:00','1','3','500000','0','1','2025-10-06 01:53:58','2025-10-06 01:53:58'), 
('0','1','open','2025-10-08','07:12:00','1','3','500000','100000','1','2025-10-08 07:13:21','2025-10-08 07:13:21');
DROP TABLE IF EXISTS `shift_openclose_detail`;
CREATE TABLE `shift_openclose_detail` (
  `id_shift_openclose_detail` int(11) unsigned NOT NULL,
  `id_shift_openclose` int(11) unsigned NOT NULL,
  `kertas100` int(11) NOT NULL DEFAULT 0,
  `kertas50` int(11) NOT NULL DEFAULT 0,
  `kertas20` int(11) NOT NULL DEFAULT 0,
  `kertas10` int(11) NOT NULL DEFAULT 0,
  `kertas5` int(11) NOT NULL DEFAULT 0,
  `kertas2` int(11) NOT NULL DEFAULT 0,
  `kertas1` int(11) NOT NULL DEFAULT 0,
  `koin1000` int(11) NOT NULL DEFAULT 0,
  `koin500` int(11) NOT NULL DEFAULT 0,
  `koin200` int(11) NOT NULL DEFAULT 0,
  `koin100` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `shift_openclose_detail` (`id_shift_openclose_detail`,`id_shift_openclose`,`kertas100`,`kertas50`,`kertas20`,`kertas10`,`kertas5`,`kertas2`,`kertas1`,`koin1000`,`koin500`,`koin200`,`koin100`,`created_at`,`updated_at`) VALUES ('1','1','3','4','5','10','20','50','50','20','20','50','100','2025-10-05 04:26:29','2025-10-05 04:26:29'), 
('2','2','4','1','0','0','0','0','50','0','0','0','0','2025-10-06 01:53:58','2025-10-06 01:53:58'), 
('0','0','4','1','0','5','0','0','0','100','0','0','0','2025-10-08 07:13:21','2025-10-08 07:13:21');
DROP TABLE IF EXISTS `stok`;
CREATE TABLE `stok` (
  `id_stok` int(11) unsigned NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `jenis` varchar(255) DEFAULT NULL,
  `jumlah` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `stok_opname`;
CREATE TABLE `stok_opname` (
  `id_stok_opname` int(11) unsigned NOT NULL,
  `id_barang` int(11) unsigned NOT NULL DEFAULT 0,
  `stok` int(11) DEFAULT NULL,
  `stok_nyata` int(11) DEFAULT NULL,
  `selisih` varchar(255) DEFAULT NULL,
  `nilai` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int(11) DEFAULT NULL,
  `id_login` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `toko`;
CREATE TABLE `toko` (
  `id_toko` int(11) NOT NULL,
  `nama_toko` varchar(255) NOT NULL,
  `alamat_toko` text NOT NULL,
  `telp` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `nama_pemilik` varchar(255) NOT NULL,
  `NIB` char(15) DEFAULT NULL,
  `PPN` char(10) DEFAULT '0',
  `include_ppn` int(11) NOT NULL DEFAULT 0,
  `kode_barang` varchar(255) DEFAULT NULL,
  `kode_jual` varchar(255) DEFAULT NULL,
  `kode_jual_tahun` int(11) DEFAULT 0,
  `kode_beli` varchar(255) DEFAULT NULL,
  `kode_kas` varchar(255) DEFAULT NULL,
  `kode_bank` varchar(255) DEFAULT NULL,
  `kode_pajak` varchar(255) DEFAULT NULL,
  `kode_biaya` varchar(255) DEFAULT NULL,
  `paper_size` char(10) DEFAULT '0',
  `footer_nota` varchar(255) DEFAULT NULL,
  `printer_usb` int(11) DEFAULT 0,
  `printer_bluetooth` int(11) DEFAULT 0,
  `scan_keranjang` int(11) DEFAULT 0,
  `id_bank_akun` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari_tanggal` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_keterangan` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_hari` int(11) NOT NULL DEFAULT 0,
  `jatuhtempo_tanggal` int(11) NOT NULL DEFAULT 0,
  `pembulatan` int(11) NOT NULL DEFAULT 0,
  `pembulatan_keatas` int(11) NOT NULL DEFAULT 0,
  `pembulatan_max` int(11) NOT NULL DEFAULT 0,
  `updated_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `toko` (`id_toko`,`nama_toko`,`alamat_toko`,`telp`,`email`,`nama_pemilik`,`NIB`,`PPN`,`include_ppn`,`kode_barang`,`kode_jual`,`kode_jual_tahun`,`kode_beli`,`kode_kas`,`kode_bank`,`kode_pajak`,`kode_biaya`,`paper_size`,`footer_nota`,`printer_usb`,`printer_bluetooth`,`scan_keranjang`,`id_bank_akun`,`jatuhtempo_hari_tanggal`,`jatuhtempo_keterangan`,`jatuhtempo_hari`,`jatuhtempo_tanggal`,`pembulatan`,`pembulatan_keatas`,`pembulatan_max`,`updated_at`) VALUES ('1','Toko Cahaya Berkah','Bojong RT 01 Rw 05','088289729445','akhyinamuazzi@gmail.com','Akhyina Muazzi','012345678','0','0','BRG-','PJ/','1','PI/','KAS/','BANK/','PPN/','BYA/','58','Terima kasih sudah berbelanja, Barang yang sudah dibeli tidak dapat dikembalikan','1','1','1','2','0','1','3','20','1','1','100','2025-10-05 06:51:44');
SET FOREIGN_KEY_CHECKS=1;
