<?php $this->extend("layouts/backend"); ?>
<?php $this->section("content"); ?>

<template>
  <h1 class="font-weight-medium mb-2"><?= $title ?></h1>

  <v-card>
    <v-card-title>
      <v-btn large color="primary" dark @click="saveBackup" elevation="1">
        <v-icon left>mdi-database-plus</v-icon> BACKUP NOW
      </v-btn>

      <v-btn large color="info" dark class="ml-2" @click="showRestoreDialog = true" elevation="1">
        <v-icon left>mdi-database-refresh</v-icon> RESTORE
      </v-btn>

      <v-spacer></v-spacer>

      <v-text-field
        v-model="search"
        append-icon="mdi-magnify"
        label="<?= lang('App.search') ?>"
        single-line
        hide-details
        clearable
      ></v-text-field>
    </v-card-title>

    <v-data-table
      :headers="dataTable"
      :items="dataBackup"
      :items-per-page="10"
      :loading="loading"
      :search="search"
      loading-text="<?= lang('App.loadingWait'); ?>"
      class="elevation-1"
    >
      <template v-slot:item="{ item }">
        <tr>
          <td>{{ item.id_backup }}</td>
          <td>{{ item.file_name }}</td>
          <td>{{ item.file_path }}</td>
          <td>{{ item.created_at }}</td>
          <td>
            <v-btn color="primary" @click="downloadItem(item)" icon>
              <v-icon>mdi-download</v-icon>
            </v-btn>
            <v-btn color="red" @click="deleteItem(item)" icon>
              <v-icon>mdi-delete</v-icon>
            </v-btn>
          </td>
        </tr>
      </template>
    </v-data-table>
  </v-card>

  <!-- Modal Restore -->
  <v-dialog v-model="showRestoreDialog" persistent max-width="500px">
    <v-card>
      <v-card-title class="headline">Restore Database</v-card-title>
      <v-card-text>
        <v-file-input
          label="Pilih file SQL untuk di-restore"
          v-model="restoreFile"
          accept=".sql"
          prepend-icon="mdi-database-import"
          outlined
          dense
        ></v-file-input>
      </v-card-text>
      <v-card-actions>
        <v-spacer></v-spacer>
        <v-btn text @click="showRestoreDialog = false">Batal</v-btn>
        <v-btn color="success" dark @click="submitRestore">Upload & Restore</v-btn>
      </v-card-actions>
    </v-card>
  </v-dialog>

  <!-- Modal Delete -->
  <v-dialog v-model="modalDelete" persistent max-width="600px">
    <v-card class="pa-2">
      <v-card-title>
        <v-icon color="error" class="mr-2" x-large>mdi-alert-octagon</v-icon>
        <?= lang('App.confirmDelete'); ?>
      </v-card-title>
      <v-card-text>
        <div class="mt-5 py-5">
          <h2 class="font-weight-regular"><?= lang('App.delConfirm'); ?></h2>
        </div>
      </v-card-text>
      <v-card-actions>
        <v-spacer></v-spacer>
        <v-btn @click="modalDelete = false" elevation="1" large>
          <?= lang('App.close'); ?>
        </v-btn>
        <v-btn color="red" dark @click="deleteData" :loading="loading" elevation="1" large>
          Hapus
        </v-btn>
        <v-spacer></v-spacer>
      </v-card-actions>
    </v-card>
  </v-dialog>

  <!-- Loading Dialog -->
  <v-dialog v-model="loading2" hide-overlay persistent width="300">
    <v-card>
      <v-card-text class="pt-3">
        <?= lang('App.loadingWait'); ?>
        <v-progress-linear indeterminate color="primary" class="mb-0"></v-progress-linear>
      </v-card-text>
    </v-card>
  </v-dialog>
</template>

<?php $this->endSection("content"); ?>


<?php $this->section("js"); ?>
<script>
  // Ambil Token Auth
  const token = JSON.parse(localStorage.getItem("access_token"));
  const options = {
    headers: {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json",
    },
  };

  // Data Vue
  dataVue = {
    ...dataVue,
    modalDelete: false,
    showRestoreDialog: false,
    restoreFile: null,
    dataBackup: [],
    dataTable: [
      { text: "ID", value: "id_backup" },
      { text: "File Name", value: "file_name" },
      { text: "File Path", value: "file_path" },
      { text: "Tanggal", value: "created_at" },
      { text: "Aksi", value: "actions", sortable: false },
    ],
    idBackup: "",
    search: "",
  };

  // Lifecycle
  createdVue = function () {
    this.getBackup();
  };

  // Methods
  methodsVue = {
    ...methodsVue,

    // 🔹 Mendapatkan daftar backup dari API
    getBackup: function () {
      this.loading = true;
      axios
        .get(`<?= base_url() ?>api/backup`, options)
        .then((res) => {
          this.loading = false;
          if (res.data.status) {
            this.dataBackup = res.data.data;
          }
        })
        .catch((err) => {
          this.loading = false;
          console.error("getBackup error:", err);
        });
    },

    // 🔹 Proses membuat backup baru
    saveBackup: function () {
      this.loading = true;
      axios
        .post(`<?= base_url() ?>api/backup/save`, {}, options)
        .then((res) => {
          this.loading = false;
          this.snackbar = true;
          this.snackbarMessage = res.data.message;
          if (res.data.status) this.getBackup();
        })
        .catch((err) => {
          this.loading = false;
          console.error("saveBackup error:", err);
        });
    },

    // 🔹 Upload & Restore Database
    submitRestore: function () {
      if (!this.restoreFile) {
        this.snackbar = true;
        this.snackbarMessage = "Silakan pilih file .sql terlebih dahulu.";
        return;
      }

      this.loading2 = true;
      const formData = new FormData();
      formData.append("file", this.restoreFile);

      axios
        .post(`<?= base_url() ?>api/backup/restore`, formData, {
          headers: {
            Authorization: `Bearer ${token}`,
            "Content-Type": "multipart/form-data",
          },
        })
        .then((res) => {
          this.loading2 = false;
          this.showRestoreDialog = false;
          this.snackbar = true;
          this.snackbarMessage = res.data.message || "Restore berhasil.";

          // Refresh tabel setelah sukses
          if (res.data.status) {
            this.getBackup();
          }
        })
        .catch((err) => {
          this.loading2 = false;
          console.error("submitRestore error:", err);
          const msg = err.response?.data?.message || "Gagal restore database.";
          this.snackbar = true;
          this.snackbarMessage = msg;
        });
    },

    // 🔹 Download file backup
    downloadItem: function (item) {
      this.loading2 = true;
      axios
        .post(`<?= base_url() ?>api/backup/download`, { id: item.id_backup }, options)
        .then((res) => {
          this.loading2 = false;
          if (res.data.status) {
            const blob = new Blob([res.data.data.url]);
            const link = document.createElement("a");
            link.href = URL.createObjectURL(blob);
            link.setAttribute("download", res.data.data.filename);
            document.body.appendChild(link);
            link.click();
          }
        })
        .catch((err) => {
          this.loading2 = false;
          console.error("downloadItem error:", err);
        });
    },

    // 🔹 Konfirmasi hapus file backup
    deleteItem: function (item) {
      this.modalDelete = true;
      this.idBackup = item.id_backup;
    },

    // 🔹 Eksekusi hapus backup
    deleteData: function () {
      this.loading = true;
      axios
        .delete(`<?= base_url() ?>api/backup/delete/${this.idBackup}`, options)
        .then((res) => {
          this.loading = false;
          this.modalDelete = false;
          this.snackbar = true;
          this.snackbarMessage = res.data.message;
          if (res.data.status) this.getBackup();
        })
        .catch((err) => {
          this.loading = false;
          console.error("deleteData error:", err);
        });
    },
  };
</script>
<?php $this->endSection("js"); ?>

