<?php

if (!isset($routes)) {
    $routes = \Config\Services::routes(true);
}

// 🔹 Route untuk halaman Backup (frontend view)
$routes->group('backup', ['filter' => 'auth', 'namespace' => 'App\Modules\Backup\Controllers'], function($routes){
    $routes->get('/', 'Backup::index', ['filter' => 'permit:viewBackup']);
});

// 🔹 Route API Backup & Restore (benar)
$routes->group('api/backup', ['namespace' => 'App\Modules\Backup\Controllers'], function($routes){
    $routes->get('/', 'Backup::index');
    $routes->post('save', 'Backup::create');
    $routes->delete('delete/(:segment)', 'Backup::delete/$1');
    $routes->post('download', 'Backup::download');
    $routes->post('restore', 'Backup::restore'); // ✅ ini akan memanggil restore() di controller kamu
});
